% validates that the string represents a percent between 0 and 100
%
%
% copyright 2011-2012 Blair Armstrong, Natasha Tokowicz, David Plaut
%
%    This file is part of eDom
%
%    eDom is free software: you can redistribute it and/or modify
%    it for academic and non-commercial purposes
%    under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.  For commercial or for-profit
%    uses, please contact the authors (blairarm@andrew.cmu.edu).
%
%    eDom is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.

%    You should have received a copy of the GNU General Public License
%    along with eDom (see COPYING.txt).
%    If not, see <http://www.gnu.org/licenses/>.

function flag = validatePercent(strNum,errmsg,errtitle)

    valid = regexp(strNum,'^[0-9]+$', 'once');
    
    if isempty(valid)
        % name is not currently valid, tell the user.
        msgbox(errmsg,...
                errtitle,'CreateMode','modal');
       flag = false;     
    else
        % we have an integer; just need to check that it is between 0 and
        % 100;
        
        n = str2num(strNum); %#ok<ST2NM>
        
        if n >= 0 && n <= 100
            flag = true;
        else
            msgbox(errmsg,...
                errtitle,'CreateMode','modal');
            flag = false;
        end
    end
    
    
end

