% gets all of the definitions stored in a specific file
%
% copyright 2011-2012 Blair Armstrong, Natasha Tokowicz, David Plaut
%
%    This file is part of eDom
%
%    eDom is free software: you can redistribute it and/or modify
%    it for academic and non-commercial purposes
%    under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.  For commercial or for-profit
%    uses, please contact the authors (blairarm@andrew.cmu.edu).
%
%    eDom is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.

%    You should have received a copy of the GNU General Public License
%    along with eDom (see COPYING.txt).
%    If not, see <http://www.gnu.org/licenses/>.

function defs = getDefinitionsFromFile(fileDir,fileName)

    fileName = fileName{1};
    %disp([fileDir,fileName]);
    
    fid = fopen([fileDir,fileName]);

    fileInfo = dir([fileDir,fileName]);
    varBuf = max(fileInfo.bytes + 1000,100) ;  

    lines = textscan(fid, '%s', 'bufSize', varBuf,'delimiter','|','EndOfLine','|');
    fclose(fid);    

    lines = lines{1}; % extract out of a cell
   
    %remove any empty lines
    newLines = {};
    for i=1:length(lines)
        if ~isempty(lines{i})
            newLines = [newLines lines(i)]; %#ok<AGROW>
        end
    end
    
    lines = newLines;
    
    defs = lines;
        
end

