% get the definitions from each file.      
%
% copyright 2011-2012 Blair Armstrong, Natasha Tokowicz, David Plaut
%
%    This file is part of eDom
%
%    eDom is free software: you can redistribute it and/or modify
%    it for academic and non-commercial purposes
%    under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.  For commercial or for-profit
%    uses, please contact the authors (blairarm@andrew.cmu.edu).
%
%    eDom is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.

%    You should have received a copy of the GNU General Public License
%    along with eDom (see COPYING.txt).
%    If not, see <http://www.gnu.org/licenses/>.

function defs = getAllDefinitions(fileDir,fileList)

    defs = {};
    for i=1:length(fileList)
        %disp(fileList);
        if ~isempty((fileList{i}))
            defs = [defs, getDefinitionsFromFile(fileDir,fileList{i})]; %#ok<AGROW> 
        end
    end
    
    newDef = '';
    for i=1:length(defs)
        % combine the definitios with a carriage return in between each
        newDef = [newDef,char(10),defs{i}]; %#ok<AGROW>
    end
    
    defs = newDef;
end
