%
% copyright 2011-2012 Blair Armstrong, Natasha Tokowicz, David Plaut
%
%    This file is part of eDom
%
%    eDom is free software: you can redistribute it and/or modify
%    it for academic and non-commercial purposes
%    under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.  For commercial or for-profit
%    uses, please contact the authors (blairarm@andrew.cmu.edu).
%
%    eDom is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.

%    You should have received a copy of the GNU General Public License
%    along with eDom (see COPYING.txt).
%    If not, see <http://www.gnu.org/licenses/>.

function varargout = figure_ratingInterface(varargin)
% FIGURE_RATINGINTERFACE M-file for figure_ratingInterface.fig
%      FIGURE_RATINGINTERFACE, by itself, creates a new FIGURE_RATINGINTERFACE or raises the existing
%      singleton*.
%
%      H = FIGURE_RATINGINTERFACE returns the handle to a new FIGURE_RATINGINTERFACE or the handle to
%      the existing singleton*.
%
%      FIGURE_RATINGINTERFACE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FIGURE_RATINGINTERFACE.M with the given input arguments.
%
%      FIGURE_RATINGINTERFACE('Property','Value',...) creates a new FIGURE_RATINGINTERFACE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before figure_ratingInterface_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to figure_ratingInterface_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help figure_ratingInterface

% Last Modified by GUIDE v2.5 01-Dec-2010 20:59:11

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @figure_ratingInterface_OpeningFcn, ...
                   'gui_OutputFcn',  @figure_ratingInterface_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before figure_ratingInterface is made visible.
function figure_ratingInterface_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to figure_ratingInterface (see VARARGIN)

% Choose default command line output for figure_ratingInterface
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

disp([char(10),char(10),'eDom Norming Software',char(10),... 
'    Copyright 2011-2012 Blair Armstrong, Natasha Tokowicz, David Plaut',char(10),... 
char(10),... 
'    This binary executable is part of eDom',char(10),... 
char(10),...
'    eDom is free software: you can redistribute it and/or modify',char(10),... 
'    it for academic and non-commercial purposes',char(10),... 
'    under the terms of the GNU General Public License as published by',char(10),... 
'    the Free Software Foundation, either version 3 of the License, or',char(10),... 
'    (at your option) any later version.  For commercial or for-profit',char(10),... 
'    uses, please contact the authors (sos@cnbc.cmu.edu).',char(10),... 
char(10),...
'    eDom is distributed in the hope that it will be useful,',char(10),... 
'    but WITHOUT ANY WARRANTY; without even the implied warranty of',char(10),... 
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the',char(10),... 
'    GNU General Public License for more details.',char(10),... 
char(10),...
'    You should have received a copy of the GNU General Public License',char(10),... 
'    along with eDom (see COPYING.txt).',char(10),... 
'    If not, see <http://www.gnu.org/licenses/>.',char(10),char(10),char(10)]);


% UIWAIT makes figure_ratingInterface wait for user response (see UIRESUME)
% uiwait(handles.figure_ratingInterface);


% --- Outputs from this function are returned to the command line.
function varargout = figure_ratingInterface_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushbutton_done.
function pushbutton_done_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_done (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
    processResponse(hObject, eventdata, handles,100);

    
    
function processResponse(hObject, eventdata, handles,sumShouldBe)
    global trialNum;
    global breakInterval;
    global myDefAdmin;


    doneTrial=finishTrial(hObject, eventdata, handles,sumShouldBe);

    if doneTrial
        if mod(trialNum+1,breakInterval) ~= 0 || trialNum == 0 || myDefAdmin.canPop() == 0 %proceed to next trial directly
            %prepare the new trial...
            prepareNewTrial(hObject,eventdata,handles);
        else
            %break time
                msgbox('You may now take a break if you would like.  Press "Resume" in the bottom right when you are ready to continue',...
                    'CreateMode','modal');
                set(handles.pushbutton_done,'Enable','off');
                set(handles.pushbutton_dontknow,'Enable','off');
                set(handles.pushbutton_resume,'Enable','on');
        end
    end


    
function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double


% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double


% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit4_Callback(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit4 as text
%        str2double(get(hObject,'String')) returns contents of edit4 as a double


% --- Executes during object creation, after setting all properties.
function edit4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit5 as text
%        str2double(get(hObject,'String')) returns contents of edit5 as a double


% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit6_Callback(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit6 as text
%        str2double(get(hObject,'String')) returns contents of edit6 as a double


% --- Executes during object creation, after setting all properties.
function edit6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit7_Callback(hObject, eventdata, handles)
% hObject    handle to edit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit7 as text
%        str2double(get(hObject,'String')) returns contents of edit7 as a double


% --- Executes during object creation, after setting all properties.
function edit7_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_1_Callback(hObject, eventdata, handles)
% hObject    handle to edit_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_1 as text
%        str2double(get(hObject,'String')) returns contents of edit_1 as a double


% --- Executes during object creation, after setting all properties.
function edit_1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_2_Callback(hObject, eventdata, handles)
% hObject    handle to edit_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_2 as text
%        str2double(get(hObject,'String')) returns contents of edit_2 as a double


% --- Executes during object creation, after setting all properties.
function edit_2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_3_Callback(hObject, eventdata, handles)
% hObject    handle to edit_3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_3 as text
%        str2double(get(hObject,'String')) returns contents of edit_3 as a double


% --- Executes during object creation, after setting all properties.
function edit_3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_4_Callback(hObject, eventdata, handles)
% hObject    handle to edit_4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_4 as text
%        str2double(get(hObject,'String')) returns contents of edit_4 as a double


% --- Executes during object creation, after setting all properties.
function edit_4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_5_Callback(hObject, eventdata, handles)
% hObject    handle to edit_5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_5 as text
%        str2double(get(hObject,'String')) returns contents of edit_5 as a double


% --- Executes during object creation, after setting all properties.
function edit_5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_6_Callback(hObject, eventdata, handles)
% hObject    handle to edit_6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_6 as text
%        str2double(get(hObject,'String')) returns contents of edit_6 as a double


% --- Executes during object creation, after setting all properties.
function edit_6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% validates all of the percent input to ensure they sum to 100.
function allflags = validateAllPercent(handles)
    allflags = 1;
    for i=1:6
        str = get(eval(['handles.edit_p',num2str(i)]),'String');

        errmsg = 'percent must be between 0 and 100';
        errtitle = 'Invalid percent!';
    
        flag = validatePercent(str,errmsg,errtitle);
        
        if flag == 0
            allflags = 0;
        end
    end
    

function edit_p1_Callback(hObject, eventdata, handles)
% hObject    handle to edit_p1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_p1 as text
%        str2double(get(hObject,'String')) returns contents of edit_p1 as a double
    validateAllPercent(handles);

% --- Executes during object creation, after setting all properties.
function edit_p1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_p1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_p2_Callback(hObject, eventdata, handles)
% hObject    handle to edit_p2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_p2 as text
%        str2double(get(hObject,'String')) returns contents of edit_p2 as a double
    validateAllPercent(handles);

% --- Executes during object creation, after setting all properties.
function edit_p2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_p2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_p3_Callback(hObject, eventdata, handles)
% hObject    handle to edit_p3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_p3 as text
%        str2double(get(hObject,'String')) returns contents of edit_p3 as a double
    validateAllPercent(handles);

% --- Executes during object creation, after setting all properties.
function edit_p3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_p3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_p4_Callback(hObject, eventdata, handles)
% hObject    handle to edit_p4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_p4 as text
%        str2double(get(hObject,'String')) returns contents of edit_p4 as a double
    validateAllPercent(handles);

% --- Executes during object creation, after setting all properties.
function edit_p4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_p4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_p5_Callback(hObject, eventdata, handles)
% hObject    handle to edit_p5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_p5 as text
%        str2double(get(hObject,'String')) returns contents of edit_p5 as a double
    validateAllPercent(handles);

% --- Executes during object creation, after setting all properties.
function edit_p5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_p5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_p6_Callback(hObject, eventdata, handles)
% hObject    handle to edit_p6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_p6 as text
%        str2double(get(hObject,'String')) returns contents of edit_p6 as a double
    validateAllPercent(handles);

% --- Executes during object creation, after setting all properties.
function edit_p6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_p6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in pushbutton_dontknow.
function pushbutton_dontknow_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_dontknow (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
 %   finishTrial(hObject, eventdata, handles,0);
     processResponse(hObject, eventdata, handles,0);


% --- Executes during object creation, after setting all properties.
function figure_ratingInterface_CreateFcn(hObject, eventdata, handles)
% hObject    handle to figure_ratingInterface (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

    global myDefAdmin;
    global trialNum;    
    global totalTrials;
    
    trialNum = -1;
    totalTrials = length(myDefAdmin.defs);
    
    


function prepareNewTrial(hObject,eventdata,handles)
    global myDefAdmin;
    global defn;
    global defOrder;
    global trialNum;
    global totalTrials;
    global startTime;
    global numUserDefs;
    
    
    startTime = tic;
    
    trialNum = trialNum + 1;
    
    % set current trial number (rounded down to nearest 10;    
    set(handles.text_percentCompleted,'String',num2str(floor(trialNum/totalTrials*10)*10));
    
    
    %first, should reset all of the fields to their defualt values.  
       for i=1:6
           set(eval(['handles.edit_',num2str(i)]),'BackgroundColor','white');
           set(eval(['handles.edit_',num2str(i)]),'String','');
           set(eval(['handles.edit_',num2str(i)]),'Enable','off');
           set(eval(['handles.edit_p',num2str(i)]),'String','0');
           set(eval(['handles.edit_p',num2str(i)]),'Enable','off');

       end    
    
    
    if myDefAdmin.canPop() == 1
       defn = myDefAdmin.pop();
       
       % set the display word..       
       set(handles.text_word,'String',defn.word);
       
       
       %next need to decide how to randomly re-order the definitions:       
       nDef = length(defn.defs);
       defOrder = randperm(nDef);
       
       defs = defn.defs;
       
       % permute the definitions;
       defs = defs(defOrder);
       
       
       % put the definitions into the gui      
       for i=1:length(defs)
           set(eval(['handles.edit_',num2str(i)]),'String',defs{i});
           set(eval(['handles.edit_',num2str(i)]),'Enable','inactive');
           set(eval(['handles.edit_p',num2str(i)]),'Enable','on');
       end
       
       %also enable a number of extra edit boxes for users to input their own
       %definitions afterwards.
       
       for i=length(defs)+1:min(6,length(defs)+numUserDefs)
           set(eval(['handles.edit_',num2str(i)]),'Enable','on');
           set(eval(['handles.edit_p',num2str(i)]),'Enable','on');
           
           % set the color of those boxes to yellow to highlight that this
           % is where they can input their own definitions.             
           set(eval(['handles.edit_',num2str(i)]),'BackgroundColor','yellow');
       end
        
    else
        % experiment should end...
        
        close(handles.figure_ratingInterface);
        
        msgbox('Experiment has ended successfully.  Please DO NOT press ok on this message open and tell the experimenter you are done','CreateMode','modal');
        msgbox('Experiment has ended successfully.  All data storage complete','CreateMode','modal');
    end
    

    

        

function trialDone=finishTrial(hObject,eventdata,handles,sumShouldBe)
    
    trialDone=0;
    
    % makes sure numbers entered ot date are valid percentages  
    valid = validateAllPercent(handles); 
    
    if valid 
        %check to see that the percentages sum to 100, and that any new
        %definitions that have been added have had a definition listed for
        %them.  
        
        percent = 0;
        for i=1:6
            num = get(eval(['handles.edit_p',num2str(i)]),'String');
            
            num= str2num(num); %#ok<ST2NM>
            
            if num < 0 || num > 100
                msgbox('Percentages must be between 0 and 100',...
                'Invalid Percent!','CreateMode','modal');
                valid = false;
            end
            
            if valid == true
                % if the field has a zero, must confirm that it isn't a
                % user-specified definition for which they have not written
                % down the new rating
                if num == 0 && strcmp(get(eval(['handles.edit_',num2str(i)]),'Enable'),'on')
                    text = get(eval(['handles.edit_',num2str(i)]),'String');
                    text=strtrim(text); 

                    if isempty(text) == 1
                        %all is well
                    else
                        msgbox('Please specify the (non-zero) percentage for the extra meaning you provided',...
                            'user provided defn. has percentage == 0','CreateMode','modal');
                        valid = false;
                    end

                elseif num > 0
                    %must check that there was text associated with the rating
                    text = get(eval(['handles.edit_',num2str(i)]),'String');
                    text=strtrim(text);

                    if isempty(text) == 0
                        % all is well, the user supplied a definition as well
                    else
                        msgbox('Please write the definition of any extra meanings you provided', ...
                             'Missing definition','CreateMode','modal');
                        valid = false;
                    end
                end
    
                percent = percent + num;

            end
        end

            
        if percent ~= sumShouldBe && valid == true 
              msgbox('Percentages must sum to 100 across all definitions unless you do not know the word, in which case all definitions should be rated as zero', ...
                        'Invalid percent','CreateMode','modal');
              valid = false;
        end

        % if all constraints have been met, the trial is at an end
        if valid == true
                    
            %here is where you'd need to save the data from the participant.  
            saveRatings(hObject, eventdata, handles, sumShouldBe)
            
            trialDone=1;
        end

    end



% --- Executes on button press in pushbutton_begin.
function pushbutton_begin_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_begin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    prepareNewTrial(hObject,eventdata,handles);
    set(handles.pushbutton_begin,'Enable','off');
    set(handles.pushbutton_done,'Enable','on');
    set(handles.pushbutton_dontknow,'Enable','on');

    
    
function saveRatings(hObject, eventdata, handles,sumShouldBe)
    % here's where the rating information will all be saved to disk.
    
    global startTime;
    global logFileName;
    global logPathName;    
    global ssIdent; 
    global defn;
    global defOrder; 
    global trialNum;
    global numUserDefs;
    
    endTime = round(toc(startTime)*1000);

    % first, let's re-order all 6 ratings back into line with the original
    % ordering.
    
    ps = [];        
    for i=1:6
        ps = [ps str2num(get(eval(['handles.edit_p',num2str(i)]),'String'))];
    end
    
     orderedP = [];
     
     for i=1:length(defOrder);
         for j=1:length(defOrder)
             if i == defOrder(j)
                 orderedP(i) = ps(j);
             end
         end
     end
     
     %pad in any additional definitions that a user may have had;     
     for i=length(defOrder)+1:6
         orderedP(i) = ps(i);
     end
     
     % we now have the ordered list of ratings.       
     biggest = max(orderedP);
     
     % find the second biggest p-value;    
     ranked =  (sort(orderedP));
     secondBiggest = ranked(5);
     
     dominance = (biggest - secondBiggest)/biggest;
     
     if biggest == orderedP(1)
         signTest = 1;
     else
         signTest = 0;
     end
     
     %open the output file to write to:     
     fid = fopen([logPathName,logFileName],'a');
     
     if sumShouldBe == 100
         known = 1;
     elseif sumShouldBe == 0
         known = 0;
         
         dominance = NaN;
         signTest = NaN;
         biggest = NaN;
         
         
         for k=1:6
             orderedP(k)=NaN;
         end
     else
         error('invalid sumShouldBe');
     end
         
     
     fprintf(fid,'%s\t%d\t%d\t%d\t%s\t%f\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\r\n', ...
            ssIdent,trialNum,known,endTime,defn.word,dominance,signTest,biggest, ...
            orderedP(1), orderedP(2), orderedP(3), orderedP(4), orderedP(5), orderedP(6));
        
     fclose(fid);
     
     
     %next, must write out any new definitions that a user may have
     %supplied for a given word.
     %don't write out hte actual dictionary definitions though...
     for i=length(defOrder)+1:min(length(defOrder)+numUserDefs,6)
            num = get(eval(['handles.edit_p',num2str(i)]),'String');            
            num= str2num(num);
            
            if num > 0
               % must write out the definition.
                    text = get(eval(['handles.edit_',num2str(i)]),'String');
                    text=strtrim(text);
                    str = '';
                    text = cellstr(text);
                    
                    for j=1:length(text);
                        str = [str,text{j},'|'];
                    end

                    fid = fopen([logPathName,logFileName,'.newDefs.txt'],'a');
                    fprintf(fid,'%s\t%d\t%s\t%d\t%s\r\n', ...
                        ssIdent,trialNum,defn.word, num, str);
                    fclose(fid);
            end
         
     end
         
    


% --- Executes on button press in pushbutton_resume.
function pushbutton_resume_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_resume (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    prepareNewTrial(hObject,eventdata,handles);
    
    set(handles.pushbutton_done,'Enable','on');
    set(handles.pushbutton_dontknow,'Enable','on');
    set(handles.pushbutton_resume,'Enable','off');
    
