% This is the backbone of the dominance rating program 
%
% copyright 2011-2012 Blair Armstrong, Natasha Tokowicz, David Plaut
%
%    This file is part of eDom
%
%    eDom is free software: you can redistribute it and/or modify
%    it for academic and non-commercial purposes
%    under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.  For commercial or for-profit
%    uses, please contact the authors (blairarm@andrew.cmu.edu).
%
%    eDom is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.

%    You should have received a copy of the GNU General Public License
%    along with eDom (see COPYING.txt).
%    If not, see <http://www.gnu.org/licenses/>.

clear
clear global

% GLOBALS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%global wordFile; % file containing the list of words participants will rate
%global defDir; % location of definition files
global logFileName;
global logPathName;
global ssIdent; % subject identifier.  
global myDefAdmin; % object that keeps track of the definitions
global breakInterval; % number of definitions between breaks.  
global numUserDefs; % number of definitions a user can add

% Fixed PARAMS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% IMPORTANT: Matlab's path should be left as the root ./eDom folder when 
% running the source code directly for these relative paths to work.  

configFile = './input/config.conf';


% BEGIN SCRIPT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load the configuration file.  
configfid = fopen(configFile);
config = textscan(configfid,'%s');
config = config{1};

%read in the options
defDir = config{1};
sampleMethod = config{2};
sampleLocation = config{3};
order = config{4};
noDefsAction = config{5};
breakInterval = config{6};
numUserDefs = config{7};


% validate the user's input from config.conf

if exist(defDir,'dir') == 0
    msgbox('Specified location of stored definitions does not exist');
    error('Specified location of stored definitions does not exist');
end

if strcmp(sampleMethod,'population') == 0 && ...
        strcmp(sampleMethod,'participantList') == 0
    msgbox('sampleMethod invalid.  Must be "population" or "participantList"');
    error('sampleMethod invalid.  Must be "population" or "participantList"');
end

if strcmp(sampleMethod,'population') 
    if exist(sampleLocation,'file') == 0
        msgbox('sample Location for sampleMethod "population" must be a file');
        error('sample Location for sampleMethod "population" must be a file');
    end
end

if strcmp(sampleMethod,'participantList') 
    if exist(sampleLocation,'dir') == 0
        msgbox('sample Location for sampleMethod "participantList" must be a directory');
        error('sample Location for sampleMethod "participantList" must be a directory');
    end
end

if strcmp(order,'fixed') == 0 && ...
        strcmp(order,'random') == 0
    msgbox('order invalid.  Must either be "fixed" or "random"');
    error('order invalid.  Must either be "fixed" or "random"');
end

if strcmp(noDefsAction,'allowNoDefs') == 0 && ...
        strcmp(noDefsAction,'denyNoDefs') == 0
    msgbox('noDefsAction invalid.  Must either be "allowNoDefs" or "denyNoDefs"');
    error('noDefsAction invalid.  Must either be "allowNoDefs" or "denyNoDefs"');
end

flag = validatePositiveInteger(breakInterval,'breakInteval is not a valid integer',...
            'Invalid input for breakInterval');

if flag
    breakInterval = str2num(breakInterval); %#ok<ST2NM>
end

flag = validatePositiveInteger(numUserDefs,'numUserDefs is not a valid integer',...
            'Invalid input for numUserDefs');

if flag
    numUserDefs = str2num(numUserDefs); %#ok<ST2NM>
end



        
% set the seed differently for each participant so their randoms are unique
rand('state',sum(100*clock)); %#ok<RAND>



% get the subject number / log file name (program generates an error if
% this is not supplied).  User is continually prompted until a legitimate
% number is entered.

logFileName = '';
logPathName = '';


while isempty(logFileName) || ...
        isempty(logPathName)

    [logFileName,logPathName] = uiputfile({'*'},'Specify subject number to save under','');
    
    flag = validatePositiveInteger(logFileName,'Must be a postive integer','Positive Integer Required');
    
    if flag == 0
        logFileName = '';
    end
end

%override any existing log files under that name...
fid = fopen([logPathName,logFileName],'w');
fclose(fid);

fid = fopen([logPathName,logFileName,'.newDefs.txt'],'w');
fclose(fid);


% set the ssid 
ssIdent = logFileName;        
 

if strcmp(sampleMethod,'population') 
    wordFile = sampleLocation;
elseif strcmp(sampleMethod,'participantList')
    wordFile = strcat(sampleLocation,ssIdent,'.txt');
end

% locate and load definitions into memory (this can take a while)
myDefAdmin = defAdmin(wordFile,defDir,order,noDefsAction);
        
% ready to start the rating interface.  
figure_ratingInterface();



