#-------------------------------------------------------------------------------
# Name:        randomizedLists
# Purpose:
#   Generates sample lists of items for individual participants from a population
#   of items.  Useful if the population is too large for each participant to
#   rate each item.  Sampling without replacement is used for each sweep through
#   the population to ensure that all items are seen the same number of times.
#
# Author:      armstrong
#
# Created:     03/02/2011
# Copyright:   (c) armstrong 2011
# Licence:     free for non-commercial academic use; by permission otherwise
# Compiler:     Python 3.0.1
#-------------------------------------------------------------------------------
#!/usr/bin/env python

import random


# USER PARAMETERS ##############################################################

# file containing the population of items to be sampled for each participant
popList = "../input/testPop.pop.txt"
outDir = "../input/participantLists/"

# maximum number of items in each list for each participant
# (must be <= population size)
# IMPORTANT: if there are fewer than listLen items left in the population when
# creating a participant list, that participant's list will only contain whatever
# items are left in the population (e.g., pop size == 150; listLen = 100; the
# first participants' list would contain 100 items but the second's would only
# contain 50.  A good approach might be to divide the population by the number of
# items that each participant should rate and round this number up, so that the
# last participant will rate only a few less items than the rest.
listLen = 3;

#permutations (participant lists) that you want to generate
# (1 sample list per participant)
perm =40;

# #############################################################################

# MAIN SCRIPT #####

# parse the population list
f = open(popList);

items = f.readlines();

for i in range(0,len(items)):
    items[i] = items[i].strip();

popLen = len(items);


if listLen > popLen:
    print("Error: sample size can't exceed population size")
    raise Exception();



# generate participant lists as samples from population

tmpItems = [];

for i in range(0,perm):
    fout = open(outDir+str(i+101)+".txt","w")

    if len(tmpItems) == 0:
        print('Population sampling without replacement complete.  Resetting population')
        tmpItems.extend(items);
        random.shuffle(tmpItems);




    #generate a list
    for  j in range(0,listLen):

        if len(tmpItems) > 0:
            fout.write(tmpItems.pop()+"\n");
            nWritten = j;

    print("Participant: " + str(i+101) + " Number of items written: " + str(nWritten+1))

    fout.close();


print('Number of participant samples generated: ' + str(perm))
print('Process complete')